/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.covers1624.jdkutils.JavaVersion;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.gson.JsonUtils;
import net.covers1624.quack.gson.LowerCaseEnumAdapterFactory;
import net.covers1624.quack.gson.MavenNotationAdapter;
import net.covers1624.quack.maven.MavenNotation;
import org.jetbrains.annotations.Nullable;

public record VersionManifest(@Nullable Arguments arguments, @Nullable Map<String, Download> downloads, @Nullable String id, @Nullable McJavaVersion javaVersion, @Nullable List<Library> libraries, @Nullable Logging logging, @Nullable String mainClass, @Nullable String minecraftArguments, int minimumLauncherVersion, @Nullable Date time, @Nullable Date releaseTime, @Nullable String type, @Nullable String inheritsFrom) {
    @Nullable
    private final Map<String, Download> downloads;
    @Nullable
    private final String id;
    @Nullable
    private final List<Library> libraries;
    @Nullable
    private final String type;
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(OS.class, (Object)new OsDeserializer()).registerTypeAdapter(MavenNotation.class, (Object)new MavenNotationAdapter()).create();

    public static VersionManifest loadFrom(Path file) throws IOException {
        return (VersionManifest)JsonUtils.parse((Gson)GSON, (Path)file, VersionManifest.class);
    }

    public static Path pathForId(Path versionsDir, String id) {
        return versionsDir.resolve(id).resolve(id + ".json");
    }

    public String id() {
        return Objects.requireNonNull(this.id);
    }

    public JavaVersion computeJavaVersion() {
        JavaVersion version = null;
        if (this.javaVersion != null) {
            version = JavaVersion.parse((String)("" + this.javaVersion.majorVersion()));
        }
        if (version == null) {
            version = JavaVersion.JAVA_1_8;
        }
        return version;
    }

    public String computeBranchName() {
        return this.type() + "/" + this.id();
    }

    public String type() {
        return Objects.requireNonNull(this.type);
    }

    public Map<String, Download> downloads() {
        return this.downloads != null ? this.downloads : Map.of();
    }

    public List<Library> libraries() {
        return this.libraries != null ? this.libraries : List.of();
    }

    public record Arguments(@JsonAdapter(value=ConditionalEntryDeserializer.class) @Nullable List<ConditionalEntry> game, @JsonAdapter(value=ConditionalEntryDeserializer.class) @Nullable List<ConditionalEntry> jvm) {
        @JsonAdapter(value=ConditionalEntryDeserializer.class)
        @Nullable
        private final List<ConditionalEntry> game;
        @JsonAdapter(value=ConditionalEntryDeserializer.class)
        @Nullable
        private final List<ConditionalEntry> jvm;

        public List<ConditionalEntry> game() {
            return this.game != null ? this.game : List.of();
        }

        public List<ConditionalEntry> jvm() {
            return this.jvm != null ? this.jvm : List.of();
        }
    }

    public record McJavaVersion(@Nullable String component, int majorVersion) {
    }

    public record Logging(@Nullable LoggingEntry client) {
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        OSX,
        UNKNOWN;

        @Nullable
        private static OS current;

        public static OS current() {
            if (current == null) {
                current = OS.parse(System.getProperty("os.name"));
            }
            return current;
        }

        static OS parse(String name) {
            if ((name = name.toLowerCase(Locale.ROOT)).contains("win")) {
                return WINDOWS;
            }
            if (name.contains("mac") || name.contains("osx")) {
                return OSX;
            }
            if (name.contains("linux")) {
                return LINUX;
            }
            return UNKNOWN;
        }
    }

    public static class OsDeserializer
    implements JsonDeserializer<OS> {
        public OS deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonPrimitive()) {
                throw new JsonParseException("OS requires a JsonPrimitive. Got: " + String.valueOf(json));
            }
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (!primitive.isString()) {
                throw new JsonParseException("OS requires a String primitive. Got:" + String.valueOf(primitive));
            }
            OS os = OS.parse(primitive.getAsString());
            if (os == OS.UNKNOWN) {
                throw new JsonParseException("Invalid OS. Got: " + primitive.getAsString());
            }
            return os;
        }
    }

    public static class ConditionalEntryDeserializer
    implements JsonDeserializer<List<ConditionalEntry>> {
        private static final Type RULES_LIST = new TypeToken<List<Rule>>(){}.getType();

        public List<ConditionalEntry> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<ConditionalEntry> entries = new ArrayList<ConditionalEntry>();
            if (!json.isJsonArray()) {
                throw new JsonParseException("Expected JsonArray. '" + String.valueOf(json) + "'");
            }
            for (JsonElement elm : json.getAsJsonArray()) {
                if (elm.isJsonPrimitive()) {
                    entries.add(new LiteralEntry(List.of(elm.getAsString())));
                    continue;
                }
                if (!(elm instanceof JsonObject)) continue;
                JsonObject obj = (JsonObject)elm;
                JsonElement value = obj.get("value");
                if (value == null) {
                    throw new JsonParseException("Missing 'value' element. '" + String.valueOf(obj) + "'");
                }
                if (!value.isJsonPrimitive() && !value.isJsonArray()) {
                    throw new JsonParseException("Expected JsonPrimitive or JsonArray. '" + String.valueOf(value) + "'");
                }
                List<String> values = value.isJsonPrimitive() ? List.of(value.getAsString()) : ConditionalEntryDeserializer.getStringList(value.getAsJsonArray());
                JsonElement rules = obj.get("rules");
                if (rules == null) {
                    throw new JsonParseException("Missing 'rules' element. '" + String.valueOf(obj) + "'");
                }
                entries.add(new RuledEntry(values, (List)context.deserialize(rules, RULES_LIST)));
            }
            return entries;
        }

        private static List<String> getStringList(JsonArray array) {
            ArrayList<String> values = new ArrayList<String>();
            for (JsonElement elm : array) {
                if (!elm.isJsonPrimitive()) {
                    throw new JsonParseException("Expected JsonPrimitive '" + String.valueOf(array) + "'");
                }
                values.add(elm.getAsString());
            }
            return List.copyOf(values);
        }
    }

    public static enum Action {
        ALLOW,
        DISALLOW;

    }

    public record RuledEntry(List<String> values, List<Rule> rules) implements ConditionalEntry
    {
        @Override
        public List<String> get(Set<String> features) {
            if (!Rule.apply(this.rules, features)) {
                return List.of();
            }
            return this.values;
        }
    }

    public record LiteralEntry(List<String> values) implements ConditionalEntry
    {
        @Override
        public List<String> get(Set<String> features) {
            return this.values;
        }
    }

    public static interface ConditionalEntry {
        public List<String> get(Set<String> var1);
    }

    public record LoggingDownload(@Nullable String id, @Nullable String sha1, long size, @Nullable String url) {
    }

    public record LoggingEntry(@Nullable String argument, @Nullable String type, @Nullable LoggingDownload file) {
    }

    public record OSRule(@Nullable OS name, @Nullable String version, @Nullable String arch) {
        public boolean applies() {
            Pattern pattern2;
            if (this.name != null && this.name != OS.current()) {
                return false;
            }
            if (this.version != null) {
                try {
                    pattern2 = Pattern.compile(this.version);
                    if (!pattern2.matcher(System.getProperty("os.version")).matches()) {
                        return false;
                    }
                }
                catch (Throwable pattern2) {
                    // empty catch block
                }
            }
            if (this.arch != null) {
                try {
                    pattern2 = Pattern.compile(this.arch);
                    if (!pattern2.matcher(System.getProperty("os.arch")).matches()) {
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }
    }

    public record Rule(@JsonAdapter(value=LowerCaseEnumAdapterFactory.class) @Nullable Action action, @Nullable OSRule os, @Nullable Map<String, Boolean> features) {
        @Nullable
        private final Map<String, Boolean> features;

        public Map<String, Boolean> features() {
            return this.features != null ? this.features : Map.of();
        }

        @Nullable
        public Action apply(Set<String> features) {
            if (this.os != null && !this.os.applies()) {
                return null;
            }
            if (this.features != null && ColUtils.anyMatch(this.features.entrySet(), e -> features.contains(e.getKey()) != ((Boolean)e.getValue()).booleanValue())) {
                return null;
            }
            return Objects.requireNonNull(this.action, "Default action can't be null.");
        }

        public static boolean apply(@Nullable List<Rule> rules, Set<String> features) {
            if (rules == null) {
                return true;
            }
            return FastStream.of(rules).map(e -> e.apply(features)).fold((Object)Action.DISALLOW, (a, b) -> b != null ? b : a) == Action.ALLOW;
        }
    }

    public record LibraryExtract(@Nullable List<String> exclude) {
        @Nullable
        private final List<String> exclude;

        public List<String> exclude() {
            return this.exclude != null ? this.exclude : List.of();
        }
    }

    public record LibraryArtifact(@Nullable String path, @Nullable String sha1, long size, @Nullable String url) {
    }

    public record LibraryDownloads(@Nullable LibraryArtifact artifact, @Nullable Map<String, LibraryArtifact> classifiers) {
        @Nullable
        private final Map<String, LibraryArtifact> classifiers;

        public Map<String, LibraryArtifact> classifiers() {
            return this.classifiers != null ? this.classifiers : Map.of();
        }
    }

    public record Library(@Nullable MavenNotation name, @Nullable LibraryExtract extract, @Nullable LibraryDownloads downloads, @Nullable List<Rule> rules, @Nullable Map<OS, String> natives, @Nullable String url) {
        @Nullable
        private final MavenNotation name;
        @Nullable
        private final Map<OS, String> natives;

        public MavenNotation name() {
            return Objects.requireNonNull(this.name);
        }

        public Map<OS, String> natives() {
            return this.natives != null ? this.natives : Map.of();
        }
    }

    public record Download(@Nullable String sha1, long size, @Nullable String url) {
        @Nullable
        private final String sha1;
        @Nullable
        private final String url;

        public String sha1() {
            return Objects.requireNonNull(this.sha1);
        }

        public String url() {
            return Objects.requireNonNull(this.url);
        }
    }

    public record AssetIndex(@Nullable String id, @Nullable String sha1, long size, long totalSize, @Nullable String url) {
    }
}

