/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util.task;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import net.javasauce.ss.util.MemoizedSupplier;
import net.javasauce.ss.util.task.TaskCacheBuilder;
import net.javasauce.ss.util.task.TaskIO;
import net.javasauce.ss.util.task.TaskInput;
import net.javasauce.ss.util.task.TaskOutput;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
    private final List<TaskInput<?>> inputs = new ArrayList();
    private final List<TaskOutput<?>> outputs = new ArrayList();
    private final String name;
    private final Executor executor;
    @Nullable
    private CompletableFuture<Task> taskFuture;
    @Nullable
    private Supplier<TaskCacheBuilder> cache;
    private final List<Task> dependsOn = new ArrayList<Task>();
    private final List<Task> innerTasks = new ArrayList<Task>();

    public Task(String name, Executor executor) {
        this.name = name;
        this.executor = executor;
    }

    public static void runTasks(Task ... tasks) {
        Task.runTasks(Arrays.asList(tasks));
    }

    public static void runTasks(Iterable<? extends Task> tasks) {
        CompletableFuture[] futures = (CompletableFuture[])FastStream.of(tasks).map(Task::getFuture).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
    }

    protected final void withCaching(TaskOutput<Path> cacheNextTo, Consumer<TaskCacheBuilder> cons) {
        this.withCaching(cacheNextTo, "", cons);
    }

    protected final void withCaching(TaskOutput<Path> cacheNextTo, String cacheSuffix, Consumer<TaskCacheBuilder> configure) {
        this.cache = new MemoizedSupplier<TaskCacheBuilder>(() -> {
            Path outputPath = (Path)cacheNextTo.get();
            TaskCacheBuilder cache = new TaskCacheBuilder(outputPath.resolveSibling(String.valueOf(outputPath.getFileName()) + cacheSuffix + ".sha1"));
            configure.accept(cache);
            return cache;
        });
    }

    protected final <T> TaskInput<T> input(String name) {
        TaskInput input = new TaskInput(this, name);
        this.inputs.add(input);
        return input;
    }

    protected final <T> TaskInput<T> input(String name, T _default) {
        TaskInput<T> input = new TaskInput<T>(this, name);
        input.set(_default);
        this.inputs.add(input);
        return input;
    }

    protected final <T> TaskInput<Optional<T>> optionalInput(String name) {
        TaskInput input = new TaskInput(this, name);
        input.set(Optional.empty());
        this.inputs.add(input);
        return input;
    }

    protected final <T> TaskInput.Collection<T> inputCollection(String name) {
        TaskInput.Collection input = new TaskInput.Collection(this, name);
        input.set(List.of());
        this.inputs.add(input);
        return input;
    }

    protected final <T> TaskOutput<T> output(String name) {
        TaskOutput output = new TaskOutput(this, name, false);
        this.outputs.add(output);
        return output;
    }

    protected final <T> TaskOutput<T> computedOutput(String name) {
        TaskOutput output = new TaskOutput(this, name, true);
        this.outputs.add(output);
        return output;
    }

    public void dependsOn(Task ... tasks) {
        this.dependsOn(Arrays.asList(tasks));
    }

    public void dependsOn(Iterable<Task> tasks) {
        tasks.forEach(this.dependsOn::add);
        this.innerTasks.forEach(task -> task.dependsOn(tasks));
    }

    protected void declareCompositeTask(Task task) {
        task.dependsOn(this.dependsOn);
        this.innerTasks.add(task);
    }

    public final synchronized CompletableFuture<Task> getFuture() {
        if (this.taskFuture == null) {
            CompletableFuture<Void> inputFuture = CompletableFuture.allOf((CompletableFuture[])FastStream.concat((Iterable[])new Iterable[]{FastStream.of(this.dependsOn).map(Task::getFuture), FastStream.of(this.innerTasks).map(Task::getFuture), FastStream.of(this.outputs).map(TaskOutput::deriveFuture).filter(Objects::nonNull), FastStream.of(this.inputs).map(TaskIO::getFuture)}).toArray(CompletableFuture[]::new));
            this.taskFuture = inputFuture.thenApplyAsync(v -> {
                try {
                    this.doExecute();
                }
                catch (Throwable ex) {
                    SneakyUtils.throwUnchecked((Throwable)ex);
                }
                return this;
            }, this.executor);
        }
        return this.taskFuture;
    }

    private void doExecute() throws Throwable {
        TaskCacheBuilder cache;
        LOGGER.info("Executing task {}", (Object)this.name);
        for (TaskInput<?> taskInput : this.inputs) {
            if (taskInput.isValueSet()) continue;
            throw new IllegalStateException("Input '" + taskInput.getName() + "' for task '" + this.getName() + "' must have a value set.");
        }
        for (TaskOutput taskOutput : this.outputs) {
            if (taskOutput.isComputed() || taskOutput.isValueSet()) continue;
            throw new IllegalStateException("Output '" + taskOutput.getName() + "' for task '" + this.getName() + "' must have a value set before its executed. Did you want a computed output instead?.");
        }
        TaskCacheBuilder taskCacheBuilder = cache = this.cache != null ? this.cache.get() : null;
        if (cache != null && cache.isUpToDate()) {
            LOGGER.info("Skipping task {}, is up-to-date.", (Object)this.name);
            return;
        }
        this.execute();
        for (TaskOutput<?> output : this.outputs) {
            if (!output.isComputed() || output.isValueSet()) continue;
            throw new IllegalStateException("Output '" + output.getName() + "' for task '" + this.getName() + "' did not produce a required output.");
        }
        if (cache != null) {
            cache.writeCache();
        }
        LOGGER.info("Task {} finished.", (Object)this.name);
    }

    protected abstract void execute() throws Throwable;

    public final String getName() {
        return this.name;
    }

    final boolean isFutureResolved() {
        return this.taskFuture != null;
    }
}

