/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util.task;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.covers1624.quack.util.SneakyUtils;
import net.javasauce.ss.util.Hashing;
import net.javasauce.ss.util.task.TaskIO;

public class TaskCacheBuilder {
    private final Path cacheFile;
    private final List<SneakyUtils.ThrowingConsumer<MessageDigest, IOException>> entries = new ArrayList<SneakyUtils.ThrowingConsumer<MessageDigest, IOException>>();

    public TaskCacheBuilder(Path cacheFile) {
        this.cacheFile = cacheFile;
    }

    public <T> void add(TaskIO<T> io) {
        this.add(io, Function.identity());
    }

    public <T, U> void add(TaskIO<T> io, Function<? super T, ? extends U> mapper) {
        this.add(mapper.apply(io.get()));
    }

    public void add(Path file) {
        this.entries.add((SneakyUtils.ThrowingConsumer<MessageDigest, IOException>)((SneakyUtils.ThrowingConsumer)e -> Hashing.tryAddFileBytes(e, file)));
    }

    public void add(CharSequence str) {
        this.entries.add((SneakyUtils.ThrowingConsumer<MessageDigest, IOException>)((SneakyUtils.ThrowingConsumer)e -> Hashing.addUTFBytes(e, str.toString())));
    }

    public void add(Number num) {
        this.entries.add((SneakyUtils.ThrowingConsumer<MessageDigest, IOException>)((SneakyUtils.ThrowingConsumer)e -> Hashing.addUTFBytes(e, num.toString())));
    }

    public void add(Object obj) {
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Path.class, CharSequence.class, Number.class, Optional.class, TaskIO.class}, (Object)object2, n)) {
            case 0: {
                Path path = (Path)object2;
                this.add(path);
                break;
            }
            case 1: {
                CharSequence str = (CharSequence)object2;
                this.add(str);
                break;
            }
            case 2: {
                Number num = (Number)object2;
                this.add(num);
                break;
            }
            case 3: {
                Optional opt = (Optional)object2;
                opt.ifPresent(this::add);
                break;
            }
            case 4: {
                TaskIO io = (TaskIO)object2;
                this.add(io);
                break;
            }
            default: {
                throw new IllegalStateException("Unable to cache value: " + String.valueOf(obj.getClass()));
            }
        }
    }

    private String hash() throws IOException {
        MessageDigest hasher = Hashing.digest("SHA-1");
        for (SneakyUtils.ThrowingConsumer<MessageDigest, IOException> entry : this.entries) {
            entry.accept((Object)hasher);
        }
        return Hashing.toString(hasher);
    }

    public boolean isUpToDate() throws IOException {
        if (Files.notExists(this.cacheFile, new LinkOption[0])) {
            return false;
        }
        String existing = Files.readString(this.cacheFile);
        return existing.equals(this.hash());
    }

    public void writeCache() throws IOException {
        Files.writeString(this.cacheFile, (CharSequence)this.hash(), new OpenOption[0]);
    }
}

