/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.covers1624.curl4j.util.CurlOutput;

public class MemoryCurlOutput
extends CurlOutput {
    private final ByteArrayOutputStream bos;

    private MemoryCurlOutput(ByteArrayOutputStream bos) {
        super(() -> Channels.newChannel(bos));
        this.bos = bos;
    }

    public static MemoryCurlOutput create() {
        return new MemoryCurlOutput(new ByteArrayOutputStream());
    }

    public String string() {
        return this.string(StandardCharsets.UTF_8);
    }

    public String string(Charset charset) {
        try {
            return this.bos.toString(charset.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Impossible.", ex);
        }
    }

    public byte[] bytes() {
        return this.bos.toByteArray();
    }
}

