/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.util.SneakyUtils;
import net.javasauce.ss.tasks.DownloadTask;
import net.javasauce.ss.util.IgnoredVersions;
import net.javasauce.ss.util.InMemoryDownload;
import net.javasauce.ss.util.JsonPretty;
import net.javasauce.ss.util.UnobfuscatedVersions;
import net.javasauce.ss.util.VersionListManifest;
import net.javasauce.ss.util.VersionManifest;
import net.javasauce.ss.util.task.Task;
import org.jetbrains.annotations.Nullable;

public class ProcessableVersionSet {
    private static final String VERSION_MANIFEST_URL = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";
    private final HttpEngine http;
    private final Path cacheDir;
    @Nullable
    private VersionListManifest listManifest;
    @Nullable
    private List<String> allVersions;
    @Nullable
    private Map<String, VersionManifest> versionManifests;

    public ProcessableVersionSet(HttpEngine http, Path cacheDir) {
        this.http = http;
        this.cacheDir = cacheDir;
    }

    public List<ChangedVersion> update() throws IOException {
        if (this.allVersions != null || this.versionManifests != null) {
            throw new IllegalStateException("Unable to update version list once manifests have been resolved.");
        }
        InMemoryDownload existingDownload = InMemoryDownload.readFrom(this.cacheDir.resolve("version_manifest_v2.json"));
        InMemoryDownload newDownload = InMemoryDownload.doDownload(this.http, VERSION_MANIFEST_URL, existingDownload);
        if (newDownload.isUpToDate()) {
            return List.of();
        }
        VersionListManifest oldListManifest = existingDownload != null ? VersionListManifest.loadFrom(existingDownload.toString()) : null;
        VersionListManifest newListManifest = VersionListManifest.loadFrom(newDownload.toString());
        newDownload.writeTo(this.cacheDir.resolve("version_manifest_v2.json"));
        oldListManifest = UnobfuscatedVersions.insert(oldListManifest);
        newListManifest = UnobfuscatedVersions.insert(newListManifest);
        HashMap oldManifests = FastStream.ofNullable((Object)oldListManifest).flatMap(this::resolveManifests).toMap(VersionManifest::id, e -> e);
        ArrayList newManifestsList = FastStream.of((Object)newListManifest).flatMap(this::resolveManifests).toList();
        LinkedHashMap newManifests = FastStream.of((Iterable)newManifestsList).toLinkedHashMap(VersionManifest::id, e -> e);
        this.populateManifests(newManifestsList);
        ArrayList<ChangedVersion> changes = new ArrayList<ChangedVersion>();
        for (VersionListManifest.Version version : newListManifest.versions()) {
            String id = version.id();
            if (IgnoredVersions.IGNORED_VERSION.contains(id)) continue;
            VersionManifest newManifest = (VersionManifest)newManifests.get(id);
            if (newManifest == null) {
                throw new RuntimeException("Missing manifest? " + id);
            }
            VersionManifest oldManifest = (VersionManifest)oldManifests.get(id);
            if (oldManifest == null) {
                changes.add(new ChangedVersion(ChangeReason.NEW, id));
                continue;
            }
            if (newManifest.equals(oldManifest)) continue;
            changes.add(new ChangedVersion(ChangeReason.CHANGED, id));
        }
        return changes;
    }

    public VersionListManifest listManifest() {
        if (this.listManifest == null) {
            try {
                InMemoryDownload manifestDownload = InMemoryDownload.readFrom(this.cacheDir.resolve("version_manifest_v2.json"));
                if (manifestDownload == null) {
                    manifestDownload = InMemoryDownload.doDownload(this.http, VERSION_MANIFEST_URL, manifestDownload);
                }
                this.listManifest = UnobfuscatedVersions.insert(VersionListManifest.loadFrom(manifestDownload.toString()));
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to load manifest.", ex);
            }
        }
        return this.listManifest;
    }

    public List<String> allVersions() {
        if (this.allVersions == null) {
            this.populateManifests();
        }
        return Objects.requireNonNull(this.allVersions);
    }

    public VersionManifest getManifest(String id) {
        return Objects.requireNonNull(this.getVersionManifests().get(id), "Version not available? " + id);
    }

    public Map<String, VersionManifest> getVersionManifests() {
        if (this.versionManifests == null) {
            this.populateManifests();
        }
        return Objects.requireNonNull(this.versionManifests);
    }

    private void populateManifests() {
        this.populateManifests(this.resolveManifests(this.listManifest()));
    }

    private void populateManifests(List<VersionManifest> manifests) {
        this.allVersions = List.copyOf(FastStream.of((Iterable)manifests.reversed()).map(VersionManifest::id).toList());
        this.versionManifests = Map.copyOf(FastStream.of((Iterable)manifests.reversed()).toLinkedHashMap(VersionManifest::id, e -> e));
    }

    private List<VersionManifest> resolveManifests(VersionListManifest listManifest) {
        ArrayList downloads = FastStream.of(listManifest.versions()).filter(e -> !IgnoredVersions.IGNORED_VERSION.contains(e.id())).map(version -> DownloadTask.create("downloadManifest_" + version.id(), ForkJoinPool.commonPool(), this.http, task -> {
            task.url.set(version.url());
            task.downloadHash.set(Optional.of(version.sha1()));
            task.output.set(VersionManifest.pathForId(this.cacheDir, version.id()));
            task.addMutator((SneakyUtils.ThrowingConsumer<Path, IOException>)((SneakyUtils.ThrowingConsumer)JsonPretty::prettyPrintJsonFile));
        })).toList();
        Task.runTasks(downloads);
        ArrayList<VersionManifest> manifests = new ArrayList<VersionManifest>();
        try {
            for (DownloadTask download : downloads) {
                manifests.add(VersionManifest.loadFrom(download.output.get()));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read manifests.", ex);
        }
        return manifests;
    }

    public record ChangedVersion(ChangeReason reason, String id) {
    }

    public static enum ChangeReason {
        CHANGED,
        NEW;

    }
}

