/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.curl4j.core;

public abstract class Library {
    public final String name;
    public final long address;

    protected Library(String name) throws UnsatisfiedLinkError {
        this.name = name;
        this.address = this.open(name);
    }

    public final long getFunction(String name) {
        long func = this.lookupAddr(name);
        if (func == 0L) {
            throw new UnsatisfiedLinkError("Unable to find required function: " + name + " in library: " + this.name);
        }
        return func;
    }

    public final long getOptionalFunction(String name) {
        return this.lookupAddr(name);
    }

    protected abstract long lookupAddr(String var1);

    public void free() {
        this.close();
    }

    protected abstract long open(String var1) throws UnsatisfiedLinkError;

    protected abstract void close();

    public static class WindowsLibrary
    extends Library {
        public WindowsLibrary(String name) throws UnsatisfiedLinkError {
            super(name);
        }

        private static native long GetModuleHandle(String var0);

        private static native int GetLastError();

        private static native long GetProcAddress(long var0, String var2);

        @Override
        protected long open(String name) throws UnsatisfiedLinkError {
            long handle = WindowsLibrary.GetModuleHandle(name);
            if (handle == 0L) {
                throw new UnsatisfiedLinkError("Failed to load dynamically linked library: '" + name + "', Error: " + WindowsLibrary.GetLastError());
            }
            return handle;
        }

        @Override
        protected void close() {
        }

        @Override
        protected long lookupAddr(String name) {
            return WindowsLibrary.GetProcAddress(this.address, name);
        }
    }

    public static class MacosLibrary
    extends UnixLibrary {
        public MacosLibrary(String name) throws UnsatisfiedLinkError {
            super(name);
        }
    }

    public static class LinuxLibrary
    extends UnixLibrary {
        public LinuxLibrary(String name) throws UnsatisfiedLinkError {
            super(name);
        }
    }

    public static abstract class UnixLibrary
    extends Library {
        private static final int RTLD_LAZY = 1;
        private static final int RTLD_NOW = 2;
        private static final int RTLD_BINDING_MASK = 3;
        private static final int RTLD_NOLOAD = 4;
        private static final int RTLD_DEEPBIND = 8;

        public UnixLibrary(String name) throws UnsatisfiedLinkError {
            super(name);
        }

        private static native long dlopen(String var0, int var1);

        private static native long dlsym(long var0, String var2);

        private static native int dlclose(long var0);

        private static native String dlerror();

        @Override
        protected long open(String name) throws UnsatisfiedLinkError {
            long handle = UnixLibrary.dlopen(name, 1);
            if (handle == 0L) {
                throw new UnsatisfiedLinkError("Failed to load dynamically linked library: '" + name + "', Error: " + UnixLibrary.dlerror());
            }
            return handle;
        }

        @Override
        protected void close() {
            UnixLibrary.dlclose(this.address);
        }

        @Override
        protected long lookupAddr(String name) {
            return UnixLibrary.dlsym(this.address, name);
        }
    }
}

