/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.report;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.WillNotClose;
import net.covers1624.quack.gson.JsonUtils;
import net.javasauce.ss.tasks.report.TestCaseState;
import org.jetbrains.annotations.Nullable;

public class TestCaseDef {
    private static final Gson GSON = new Gson();
    public Map<String, Case> cases = new LinkedHashMap<String, Case>();

    public static TestCaseDef loadTestStats(Path testStats) {
        TestCaseDef testCaseDef;
        block8: {
            InputStream is = Files.newInputStream(testStats, new OpenOption[0]);
            try {
                testCaseDef = TestCaseDef.loadTestStats(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            is.close();
        }
        return testCaseDef;
    }

    public static TestCaseDef loadTestStats(@WillNotClose InputStream is) throws IOException {
        TestCaseDef defs = (TestCaseDef)JsonUtils.parse((Gson)GSON, (InputStream)is, TestCaseDef.class);
        for (Case c : defs.cases.values()) {
            if (c.broken == null) continue;
            c.target = TestCaseState.BROKEN;
        }
        return defs;
    }

    public static class Case {
        @Nullable
        public TestCaseState target;
        @Nullable
        public BrokenDef broken;
    }

    public static class BrokenDef {
        @Nullable
        public String exception;
        public boolean ignoreMessage = false;
        @Nullable
        public String message;
    }
}

