/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.covers1624.quack.collection.ColUtils;
import net.javasauce.ss.tasks.report.TestCaseDef;
import net.javasauce.ss.tasks.report.TestCaseState;

public class ReportTableGenerator {
    private static final List<TestCaseState> ORDER = TestCaseState.VALUES.reversed();
    private final List<String> table = new ArrayList<String>();

    public ReportTableGenerator() {
        this.table.add("<table>");
        this.table.add("<tr>");
        this.table.add("<td>Version</td>");
        for (TestCaseState state : ORDER) {
            ReportTableGenerator.emitTableCell(this.table, state.humanName);
        }
        this.table.add("</tr>");
    }

    public ReportTableGenerator addRow(String id, TestCaseDef def, String repo, String branch) {
        if (this.table.isEmpty()) {
            throw new RuntimeException("Already finished building.");
        }
        int[] stats = ReportTableGenerator.sumCases(def);
        this.table.add("<tr>");
        ReportTableGenerator.emitTableCell(this.table, "[" + id + "](" + repo + "/tree/" + branch + ")");
        for (TestCaseState state : ORDER) {
            ReportTableGenerator.emitTableCell(this.table, "" + stats[state.ordinal()]);
        }
        this.table.add("</tr>");
        return this;
    }

    public String build() {
        if (this.table.isEmpty()) {
            throw new RuntimeException("Already finished building.");
        }
        this.table.add("</table>");
        String builtTable = String.join((CharSequence)"\n", this.table);
        this.table.clear();
        return builtTable;
    }

    private static void emitTableCell(List<String> table, String cellContent) {
        ReportTableGenerator.emitTableCell(table, List.of(cellContent));
    }

    private static void emitTableCell(List<String> table, List<String> cellContent) {
        if (ColUtils.allMatch(cellContent, String::isEmpty)) {
            table.add("<td></td>");
        } else if (ColUtils.anyMatch(cellContent, e -> e.contains("`") || e.contains("[") && e.contains("]"))) {
            table.add("<td>");
            table.add("");
            table.addAll(cellContent);
            table.add("");
            table.add("</td>");
        } else if (cellContent.size() == 1) {
            table.add("<td>" + cellContent.getFirst() + "</td>");
        } else {
            table.add("<td>");
            table.addAll(cellContent);
            table.add("</td>");
        }
    }

    private static int[] sumCases(TestCaseDef def) {
        int[] numCases = new int[4];
        for (Map.Entry<String, TestCaseDef.Case> c : def.cases.entrySet()) {
            int n = c.getValue().target.ordinal();
            numCases[n] = numCases[n] + 1;
        }
        return numCases;
    }
}

