/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.selector;

import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Singleton;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.spi.LoggerContextShutdownAware;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;

@Singleton
public class BasicContextSelector
implements ContextSelector,
LoggerContextShutdownAware {
    private static final Logger LOGGER = StatusLogger.getLogger();
    protected final Lazy<LoggerContext> context = Lazy.lazy(this::createContext);
    protected final ConfigurableInstanceFactory instanceFactory;

    @Inject
    public BasicContextSelector(ConfigurableInstanceFactory instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    @Override
    public void shutdown(String fqcn, ClassLoader loader, boolean currentContext, boolean allContexts) {
        LoggerContext ctx = this.getContext(fqcn, loader, currentContext);
        if (ctx != null && ctx.isStarted()) {
            ctx.stop(50L, TimeUnit.MILLISECONDS);
        }
    }

    public void contextShutdown(org.apache.logging.log4j.spi.LoggerContext loggerContext) {
        if (loggerContext instanceof LoggerContext) {
            this.removeContext((LoggerContext)loggerContext);
        }
    }

    @Override
    public boolean hasContext(String fqcn, ClassLoader loader, boolean currentContext) {
        LoggerContext ctx = this.getContext(fqcn, loader, currentContext);
        return ctx != null && ctx.isStarted();
    }

    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        return this.getContext(fqcn, loader, currentContext, null);
    }

    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
        LoggerContext ctx;
        if (currentContext && (ctx = ContextAnchor.THREAD_CONTEXT.get()) != null) {
            return ctx;
        }
        ctx = (LoggerContext)this.context.get();
        if (configLocation != null) {
            if (ctx.getConfigLocation() == null) {
                LOGGER.debug("Setting configuration to {}", (Object)configLocation);
                ctx.setConfigLocation(configLocation);
            } else if (!ctx.getConfigLocation().equals(configLocation)) {
                LOGGER.warn("getContext called with URI {}. Existing LoggerContext has URI {}", (Object)configLocation, (Object)ctx.getConfigLocation());
            }
        }
        return ctx;
    }

    @Override
    public void removeContext(LoggerContext context) {
        if (context == this.context.get()) {
            this.context.set(null);
        }
    }

    @Override
    public boolean isClassLoaderDependent() {
        return false;
    }

    @Override
    public List<LoggerContext> getLoggerContexts() {
        return List.of((LoggerContext)this.context.get());
    }

    protected LoggerContext createContext() {
        return new LoggerContext("Default", null, (URI)null, this.instanceFactory);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

