/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.OrderComparator;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.model.PluginNamespace;
import org.apache.logging.log4j.spi.LoggingSystemProperty;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyEnvironment;
import org.apache.logging.log4j.util.PropertyKey;
import org.apache.logging.log4j.util.Strings;

public class DefaultConfigurationFactory
extends ConfigurationFactory {
    private static final String ALL_TYPES = "*";
    private static final String OVERRIDE_PARAM = "override";
    private final Lazy<List<ConfigurationFactory>> configurationFactories = Lazy.lazy(() -> DefaultConfigurationFactory.loadConfigurationFactories(instanceFactory));
    private final StrSubstitutor substitutor;

    @Inject
    public DefaultConfigurationFactory(ConfigurableInstanceFactory instanceFactory, StrSubstitutor substitutor) {
        this.substitutor = substitutor;
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        Configuration config;
        if (configLocation == null) {
            String configLocationStr;
            PropertyEnvironment properties = loggerContext.getProperties();
            if (properties == null) {
                properties = PropertiesUtil.getProperties();
            }
            if ((configLocationStr = this.substitutor.replace(properties.getStringProperty((PropertyKey)Log4jPropertyKey.CONFIG_LOCATION))) != null) {
                String[] sources = this.parseConfigLocations(configLocationStr);
                if (sources.length > 1) {
                    ArrayList<AbstractConfiguration> configs = new ArrayList<AbstractConfiguration>();
                    for (String sourceLocation : sources) {
                        Configuration config2 = this.getConfiguration(loggerContext, sourceLocation.trim());
                        if (config2 != null) {
                            if (config2 instanceof AbstractConfiguration) {
                                configs.add((AbstractConfiguration)config2);
                                continue;
                            }
                            LOGGER.error("Failed to created configuration at {}", (Object)sourceLocation);
                            return null;
                        }
                        LOGGER.warn("Unable to create configuration for {}, ignoring", (Object)sourceLocation);
                    }
                    if (configs.size() > 1) {
                        return new CompositeConfiguration(configs);
                    }
                    if (configs.size() == 1) {
                        return (Configuration)configs.get(0);
                    }
                }
                return this.getConfiguration(loggerContext, configLocationStr);
            }
            String log4j1ConfigStr = this.substitutor.replace(properties.getStringProperty(LOG4J1_CONFIGURATION_FILE_PROPERTY));
            if (log4j1ConfigStr != null) {
                System.setProperty(LOG4J1_EXPERIMENTAL.getSystemKey(), "true");
                return this.getConfiguration("1", loggerContext, log4j1ConfigStr);
            }
            for (ConfigurationFactory factory : (List)this.configurationFactories.get()) {
                String[] types = factory.getSupportedTypes();
                if (types == null) continue;
                for (String type : types) {
                    Configuration config3;
                    if (!type.equals(ALL_TYPES) || (config3 = factory.getConfiguration(loggerContext, name, null)) == null) continue;
                    return config3;
                }
            }
        } else {
            String[] sources = this.parseConfigLocations(configLocation);
            if (sources.length > 1) {
                ArrayList<AbstractConfiguration> configs = new ArrayList<AbstractConfiguration>();
                for (String sourceLocation : sources) {
                    Configuration config4 = this.getConfiguration(loggerContext, sourceLocation.trim());
                    if (!(config4 instanceof AbstractConfiguration)) {
                        LOGGER.error("Failed to created configuration at {}", (Object)sourceLocation);
                        return null;
                    }
                    configs.add((AbstractConfiguration)config4);
                }
                return new CompositeConfiguration(configs);
            }
            String configLocationStr = configLocation.toString();
            for (ConfigurationFactory factory : (List)this.configurationFactories.get()) {
                String[] types = factory.getSupportedTypes();
                if (types == null) continue;
                for (String type : types) {
                    Configuration config5;
                    if (!type.equals(ALL_TYPES) && !configLocationStr.endsWith(type) || (config5 = factory.getConfiguration(loggerContext, name, configLocation)) == null) continue;
                    return config5;
                }
            }
        }
        if ((config = this.getConfiguration(loggerContext, true, name)) == null && (config = this.getConfiguration(loggerContext, true, null)) == null && (config = this.getConfiguration(loggerContext, false, name)) == null) {
            config = this.getConfiguration(loggerContext, false, null);
        }
        if (config != null) {
            return config;
        }
        LOGGER.warn("No Log4j 2 configuration file found. Using default configuration (logging only errors to the console), or user programmatically provided configurations. Set system property 'log4j2.*.{}' to show Log4j 2 internal initialization logging. See https://logging.apache.org/log4j/2.x/manual/configuration.html for instructions on how to configure Log4j 2", (Object)LoggingSystemProperty.STATUS_LOGGER_DEBUG);
        return new DefaultConfiguration();
    }

    private Configuration getConfiguration(LoggerContext loggerContext, String configLocationStr) {
        return this.getConfiguration(null, loggerContext, configLocationStr);
    }

    private Configuration getConfiguration(String requiredVersion, LoggerContext loggerContext, String configLocationStr) {
        ConfigurationSource source = null;
        try {
            source = ConfigurationSource.fromUri(NetUtils.toURI(configLocationStr));
        }
        catch (Exception ex) {
            LOGGER.catching(Level.DEBUG, (Throwable)ex);
        }
        if (source != null) {
            for (ConfigurationFactory factory : (List)this.configurationFactories.get()) {
                String[] types;
                if (requiredVersion != null && !factory.getVersion().equals(requiredVersion) || (types = factory.getSupportedTypes()) == null) continue;
                for (String type : types) {
                    Configuration config;
                    if (!type.equals(ALL_TYPES) && !configLocationStr.endsWith(type) || (config = factory.getConfiguration(loggerContext, source)) == null) continue;
                    return config;
                }
            }
        }
        return null;
    }

    private Configuration getConfiguration(LoggerContext loggerContext, boolean isTest, String name) {
        boolean named = Strings.isNotEmpty((CharSequence)name);
        ClassLoader loader = LoaderUtil.getThreadContextClassLoader();
        for (ConfigurationFactory factory : (List)this.configurationFactories.get()) {
            String prefix = isTest ? factory.getTestPrefix() : factory.getDefaultPrefix();
            String[] types = factory.getSupportedTypes();
            if (types == null) continue;
            for (String suffix : types) {
                String configName;
                ConfigurationSource source;
                if (suffix.equals(ALL_TYPES) || (source = ConfigurationSource.fromResource(configName = named ? prefix + name + suffix : prefix + suffix, loader)) == null) continue;
                if (!factory.isActive()) {
                    LOGGER.warn("Found configuration file {} for inactive ConfigurationFactory {}", (Object)configName, (Object)factory.getClass().getName());
                }
                return factory.getConfiguration(loggerContext, source);
            }
        }
        return null;
    }

    @Override
    public String[] getSupportedTypes() {
        return null;
    }

    @Override
    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        if (source != null) {
            String config = source.getLocation();
            for (ConfigurationFactory factory : (List)this.configurationFactories.get()) {
                String[] types = factory.getSupportedTypes();
                if (types == null) continue;
                for (String type : types) {
                    if (!type.equals(ALL_TYPES) && (config == null || !config.endsWith(type))) continue;
                    Configuration c = factory.getConfiguration(loggerContext, source);
                    if (c != null) {
                        LOGGER.debug("Loaded configuration from {}", (Object)source);
                        return c;
                    }
                    LOGGER.error("Cannot determine the ConfigurationFactory to use for {}", (Object)config);
                    return null;
                }
            }
        }
        LOGGER.error("Cannot process configuration, input source is null");
        return null;
    }

    private String[] parseConfigLocations(URI configLocations) {
        String[] uris = configLocations.toString().split("\\?");
        ArrayList<String> locations = new ArrayList<String>();
        if (uris.length > 1) {
            String[] pairs;
            locations.add(uris[0]);
            for (String pair : pairs = configLocations.getQuery().split("&")) {
                String key;
                int idx = pair.indexOf("=");
                String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8) : pair;
                if (!key.equalsIgnoreCase(OVERRIDE_PARAM)) continue;
                locations.add(URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8));
            }
            return locations.toArray(new String[0]);
        }
        return new String[]{uris[0]};
    }

    private String[] parseConfigLocations(String configLocations) {
        String[] uris = configLocations.split(",");
        if (uris.length > 1) {
            return uris;
        }
        try {
            return this.parseConfigLocations(new URI(configLocations));
        }
        catch (URISyntaxException ex) {
            LOGGER.warn("Error parsing URI {}", (Object)configLocations);
            return new String[]{configLocations};
        }
    }

    private static List<ConfigurationFactory> loadConfigurationFactories(ConfigurableInstanceFactory instanceFactory) {
        ArrayList<ConfigurationFactory> factories = new ArrayList<ConfigurationFactory>();
        Optional.ofNullable(PropertiesUtil.getProperties().getStringProperty((PropertyKey)Log4jPropertyKey.CONFIG_CONFIGURATION_FACTORY_CLASS_NAME)).flatMap(DefaultConfigurationFactory::tryLoadFactoryClass).map(clazz -> {
            try {
                return (ConfigurationFactory)instanceFactory.getInstance(clazz);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to create instance of {}", clazz, (Object)ex);
                return null;
            }
        }).ifPresent(factories::add);
        ArrayList configurationFactoryPluginClasses = new ArrayList();
        ((PluginNamespace)instanceFactory.getInstance(PLUGIN_NAMESPACE_KEY)).forEach(type -> {
            try {
                configurationFactoryPluginClasses.add(type.getPluginClass().asSubclass(ConfigurationFactory.class));
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to add class {}", (Object)type.getPluginClass(), (Object)ex);
            }
        });
        configurationFactoryPluginClasses.sort(OrderComparator.getInstance());
        configurationFactoryPluginClasses.forEach(clazz -> {
            try {
                factories.add((ConfigurationFactory)instanceFactory.getInstance(clazz));
            }
            catch (Exception ex) {
                LOGGER.error("Unable to create instance of {}", clazz, (Object)ex);
            }
        });
        return factories;
    }

    private static Optional<Class<? extends ConfigurationFactory>> tryLoadFactoryClass(String factoryClass) {
        try {
            return Optional.of(Loader.loadClass(factoryClass).asSubclass(ConfigurationFactory.class));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to load ConfigurationFactory class {}", (Object)factoryClass, (Object)ex);
            return Optional.empty();
        }
    }
}

