/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.util;

import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.covers1624.quack.io.CopyingFileVisitor;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskInput;
import net.javasauce.ss.util.task.TaskOutput;

public class CopyTask
extends Task {
    public final TaskInput<Path> input = this.input("input");
    public final TaskOutput<Path> output = this.output("output");

    private CopyTask(String name, Executor executor) {
        super(name, executor);
    }

    public static CopyTask create(String name, Executor executor, Consumer<CopyTask> cons) {
        CopyTask task = new CopyTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        Path input = this.input.get();
        Path output = this.output.get();
        if (Files.isDirectory(input, new LinkOption[0])) {
            if (Files.exists(output, new LinkOption[0]) && !Files.isDirectory(output, new LinkOption[0])) {
                throw new IOException("Expected output to be directory for directory copy.");
            }
            Files.walkFileTree(input, (FileVisitor<? super Path>)new CopyingFileVisitor(input, output));
        } else {
            Path fileOutput = output;
            if (Files.exists(output, new LinkOption[0]) && Files.isDirectory(output, new LinkOption[0])) {
                fileOutput = output.resolve(input.getFileName());
            }
            Files.copy(input, fileOutput, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

