/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.status;

import java.io.PrintStream;
import java.text.DateFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.ParameterizedNoReferenceMessageFactory;
import org.apache.logging.log4j.simple.SimpleLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.status.StatusLoggerConfiguration;
import org.apache.logging.log4j.util.PropertiesUtil;

class StatusLoggerFactory {
    private static final String STATUS_LOGGER = "StatusLogger";
    private final StatusLoggerConfiguration configuration;

    StatusLoggerFactory(StatusLoggerConfiguration configuration) {
        this.configuration = configuration;
    }

    SimpleLogger createSimpleLogger(String name, Level loggerLevel, PrintStream stream) {
        DateFormat dateFormat;
        return new SimpleLogger(name, ParameterizedNoReferenceMessageFactory.INSTANCE, stream, loggerLevel, dateFormat, (dateFormat = this.configuration.getDateTimeFormat()) != null);
    }

    StatusLogger createStatusLogger() {
        Level loggerLevel = this.configuration.isDebugEnabled() ? Level.TRACE : Level.ERROR;
        SimpleLogger logger = this.createSimpleLogger(STATUS_LOGGER, loggerLevel, System.err);
        return new StatusLogger(logger, this.configuration);
    }

    static StatusLoggerFactory getInstance() {
        return new StatusLoggerFactory(new StatusLoggerConfiguration(PropertiesUtil.getProperties(STATUS_LOGGER)));
    }
}

