/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.validation.validators;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.plugins.validation.constraints.ValidPort;
import org.apache.logging.log4j.status.StatusLogger;

public class ValidPortValidator
implements ConstraintValidator<ValidPort> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ValidPort annotation;

    @Override
    public void initialize(ValidPort annotation) {
        this.annotation = annotation;
    }

    @Override
    public boolean isValid(String name, Object value) {
        int port;
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            port = i;
        } else if (value instanceof CharSequence) {
            CharSequence cs = (CharSequence)value;
            try {
                port = Integer.parseInt(cs, 0, cs.length(), 10);
            }
            catch (NumberFormatException ignored) {
                LOGGER.error(this.annotation.message());
                return false;
            }
        } else {
            LOGGER.error(this.annotation.message());
            return false;
        }
        if (port < 0 || port > 65535) {
            LOGGER.error(this.annotation.message());
            return false;
        }
        return true;
    }
}

