/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.core.util.CloseShieldOutputStream;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyEnvironment;
import org.apache.logging.log4j.util.PropertyKey;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.SystemPropertiesPropertySource;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="Console")
public final class ConsoleAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    public static final String PLUGIN_NAME = "Console";
    private static final String JANSI_CLASS = "org.fusesource.jansi.WindowsAnsiOutputStream";
    private static final ConsoleManagerFactory factory = new ConsoleManagerFactory();
    private static final Target DEFAULT_TARGET = Target.SYSTEM_OUT;
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final Target target;
    private static final PropertiesUtil sysProps = new PropertiesUtil((PropertySource)new SystemPropertiesPropertySource());

    private ConsoleAppender(String name, Layout layout, Filter filter, OutputStreamManager manager, boolean ignoreExceptions, Target target, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, true, properties, manager);
        this.target = target;
    }

    public static ConsoleAppender createDefaultAppenderForLayout(Layout layout) {
        return new ConsoleAppender("DefaultConsole-" + COUNT.incrementAndGet(), layout, null, ConsoleAppender.getDefaultManager(DEFAULT_TARGET, false, false, layout), true, DEFAULT_TARGET, null);
    }

    @PluginFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private static OutputStreamManager getDefaultManager(Target target, boolean follow, boolean direct, Layout layout) {
        OutputStream os = ConsoleAppender.getOutputStream(follow, direct, target, (PropertyEnvironment)PropertiesUtil.getProperties());
        String managerName = target.name() + "." + follow + "." + direct + "-" + COUNT.get();
        return OutputStreamManager.getManager(managerName, new FactoryData(os, managerName, layout), factory);
    }

    private static OutputStreamManager getManager(Target target, boolean follow, boolean direct, Layout layout, PropertyEnvironment properties) {
        OutputStream os = ConsoleAppender.getOutputStream(follow, direct, target, properties);
        String managerName = target.name() + "." + follow + "." + direct;
        return OutputStreamManager.getManager(managerName, new FactoryData(os, managerName, layout), factory);
    }

    private static OutputStream getOutputStream(boolean follow, boolean direct, Target target, PropertyEnvironment properties) {
        OutputStream outputStream;
        String enc = Charset.defaultCharset().name();
        try {
            outputStream = target == Target.SYSTEM_OUT ? (direct ? new FileOutputStream(FileDescriptor.out) : (follow ? new PrintStream((OutputStream)new SystemOutStream(), true, enc) : System.out)) : (direct ? new FileOutputStream(FileDescriptor.err) : (follow ? new PrintStream((OutputStream)new SystemErrStream(), true, enc) : System.err));
            outputStream = new CloseShieldOutputStream(outputStream);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unsupported default encoding " + enc, ex);
        }
        if (!properties.isOsWindows() || properties.getBooleanProperty((PropertyKey)Log4jPropertyKey.CONSOLE_JANSI_ENABLED, true) || direct) {
            return outputStream;
        }
        try {
            Class<?> clazz = Loader.loadClass(JANSI_CLASS);
            Constructor<?> constructor = clazz.getConstructor(OutputStream.class);
            return new CloseShieldOutputStream((OutputStream)constructor.newInstance(outputStream));
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.debug("Jansi is not installed, cannot find {}", (Object)JANSI_CLASS);
        }
        catch (NoSuchMethodException nsme) {
            LOGGER.warn("{} is missing the proper constructor", (Object)JANSI_CLASS);
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to instantiate {} due to {}", (Object)JANSI_CLASS, (Object)ConsoleAppender.clean(Throwables.getRootCause(ex).toString()).trim());
        }
        return outputStream;
    }

    private static String clean(String string) {
        return string.replace('\u0000', ' ');
    }

    public Target getTarget() {
        return this.target;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Target {
        SYSTEM_OUT{

            @Override
            public Charset getDefaultCharset() {
                return this.getCharset("sun.stdout.encoding", Charset.defaultCharset());
            }
        }
        ,
        SYSTEM_ERR{

            @Override
            public Charset getDefaultCharset() {
                return this.getCharset("sun.stderr.encoding", Charset.defaultCharset());
            }
        };


        public abstract Charset getDefaultCharset();

        protected Charset getCharset(String property, Charset defaultCharset) {
            return sysProps.getCharsetProperty(property, defaultCharset);
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<ConsoleAppender> {
        @PluginBuilderAttribute
        @Required
        private Target target = DEFAULT_TARGET;
        @PluginBuilderAttribute
        private boolean follow;
        @PluginBuilderAttribute
        private boolean direct;

        public B setTarget(Target aTarget) {
            this.target = aTarget;
            return (B)((Builder)this.asBuilder());
        }

        public B setFollow(boolean shouldFollow) {
            this.follow = shouldFollow;
            return (B)((Builder)this.asBuilder());
        }

        public B setDirect(boolean shouldDirect) {
            this.direct = shouldDirect;
            return (B)((Builder)this.asBuilder());
        }

        public ConsoleAppender build() {
            if (this.follow && this.direct) {
                throw new IllegalArgumentException("Cannot use both follow and direct on ConsoleAppender '" + this.getName() + "'");
            }
            Layout layout = this.getOrCreateLayout(this.target.getDefaultCharset());
            Configuration configuration = this.getConfiguration();
            PropertiesUtil propertyEnvironment = configuration != null && configuration.getLoggerContext() != null ? configuration.getLoggerContext().getProperties() : PropertiesUtil.getProperties();
            return new ConsoleAppender(this.getName(), layout, this.getFilter(), ConsoleAppender.getManager(this.target, this.follow, this.direct, layout, (PropertyEnvironment)propertyEnvironment), this.isIgnoreExceptions(), this.target, this.getPropertyArray());
        }
    }

    private static class FactoryData {
        private final OutputStream os;
        private final String name;
        private final Layout layout;

        public FactoryData(OutputStream os, String type, Layout layout) {
            this.os = os;
            this.name = type;
            this.layout = layout;
        }
    }

    private static class ConsoleManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private ConsoleManagerFactory() {
        }

        @Override
        public OutputStreamManager createManager(String name, FactoryData data) {
            return new OutputStreamManager(data.os, data.name, data.layout, true);
        }
    }

    private static class SystemOutStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.out.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            System.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            System.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            System.out.write(b);
        }
    }

    private static class SystemErrStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.err.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            System.err.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            System.err.write(b, off, len);
        }

        @Override
        public void write(int b) {
            System.err.write(b);
        }
    }
}

