/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DefaultAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyKey;

public class AsyncQueueFullPolicyFactory {
    static final String PROPERTY_VALUE_DEFAULT_ASYNC_EVENT_ROUTER = "Default";
    static final String PROPERTY_VALUE_DISCARDING_ASYNC_EVENT_ROUTER = "Discard";
    private static final Logger LOGGER = StatusLogger.getLogger();

    public static AsyncQueueFullPolicy create() {
        String router = PropertiesUtil.getProperties().getStringProperty((PropertyKey)Log4jPropertyKey.ASYNC_LOGGER_QUEUE_FULL_POLICY);
        if (router == null || AsyncQueueFullPolicyFactory.isRouterSelected(router, DefaultAsyncQueueFullPolicy.class, PROPERTY_VALUE_DEFAULT_ASYNC_EVENT_ROUTER)) {
            return new DefaultAsyncQueueFullPolicy();
        }
        if (AsyncQueueFullPolicyFactory.isRouterSelected(router, DiscardingAsyncQueueFullPolicy.class, PROPERTY_VALUE_DISCARDING_ASYNC_EVENT_ROUTER)) {
            return AsyncQueueFullPolicyFactory.createDiscardingAsyncQueueFullPolicy();
        }
        return AsyncQueueFullPolicyFactory.createCustomRouter(router);
    }

    private static boolean isRouterSelected(String propertyValue, Class<? extends AsyncQueueFullPolicy> policy, String shortPropertyValue) {
        return propertyValue != null && (shortPropertyValue.equalsIgnoreCase(propertyValue) || policy.getName().equals(propertyValue) || policy.getSimpleName().equals(propertyValue));
    }

    private static AsyncQueueFullPolicy createCustomRouter(String router) {
        try {
            LOGGER.debug("Creating custom AsyncQueueFullPolicy '{}'", (Object)router);
            return (AsyncQueueFullPolicy)LoaderUtil.newCheckedInstanceOf((String)router, AsyncQueueFullPolicy.class);
        }
        catch (Exception ex) {
            LOGGER.debug("Using DefaultAsyncQueueFullPolicy. Could not create custom AsyncQueueFullPolicy '{}': {}", (Object)router, (Object)ex.getMessage(), (Object)ex);
            return new DefaultAsyncQueueFullPolicy();
        }
    }

    private static AsyncQueueFullPolicy createDiscardingAsyncQueueFullPolicy() {
        PropertiesUtil properties = PropertiesUtil.getProperties();
        String level = properties.getStringProperty((PropertyKey)Log4jPropertyKey.ASYNC_LOGGER_DISCARD_THRESHOLD, Level.INFO.name());
        Level thresholdLevel = Level.toLevel((String)level, (Level)Level.INFO);
        LOGGER.debug("Creating custom DiscardingAsyncQueueFullPolicy(discardThreshold:{})", (Object)thresholdLevel);
        return new DiscardingAsyncQueueFullPolicy(thresholdLevel);
    }
}

