/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.util;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.javasauce.ss.util.CommittedTestCasePair;
import net.javasauce.ss.util.ProcessableVersionSet;
import net.javasauce.ss.util.ReportTableGenerator;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskInput;

public class GenerateRootProjectTask
extends Task {
    public final TaskInput<Path> projectDir = this.input("projectDir");
    public final TaskInput<ProcessableVersionSet> versions = this.input("versions");
    public final TaskInput<Map<String, CommittedTestCasePair>> testDefs = this.input("testDefs");
    public final TaskInput<String> gitRepoUrl = this.input("gitRepoUrl");

    private GenerateRootProjectTask(String name, Executor executor) {
        super(name, executor);
    }

    public static GenerateRootProjectTask create(String name, Executor executor, Consumer<GenerateRootProjectTask> cons) {
        GenerateRootProjectTask task = new GenerateRootProjectTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        Path projectDir = this.projectDir.get();
        Files.writeString(projectDir.resolve(".gitignore"), (CharSequence)this.buildGitIgnore(), new OpenOption[0]);
        Files.writeString(projectDir.resolve("README.md"), (CharSequence)this.buildReadme(), new OpenOption[0]);
    }

    private String buildGitIgnore() {
        return "# exclude all\n/*\n\n# Include Important Folders\n!cache/\n\n# Include git important files\n!.gitignore\n\n# Other files.\n!README.md\n";
    }

    private String buildReadme() {
        ProcessableVersionSet versions = this.versions.get();
        Map<String, CommittedTestCasePair> testDefs = this.testDefs.get();
        String gitRepoUrl = this.gitRepoUrl.get();
        Object readme = "# Shoveled\nOutput of SnowShovel\n";
        ReportTableGenerator generator = new ReportTableGenerator();
        for (String id : versions.allVersions().reversed()) {
            CommittedTestCasePair testDef = testDefs.get(id);
            if (testDef == null) continue;
            generator.addRow(id, testDef.now().def(), gitRepoUrl, versions.getManifest(id).computeBranchName());
        }
        readme = (String)readme + generator.build();
        return readme;
    }
}

