/*
 * Decompiled with CFR 0.152.
 */
package net.javasauce.ss.tasks.report;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.javasauce.ss.tasks.report.GenerateComparisonsTask;
import net.javasauce.ss.tasks.report.TestCaseState;
import net.javasauce.ss.util.CommittedTestCasePair;
import net.javasauce.ss.util.DiscordWebhook;
import net.javasauce.ss.util.task.Task;
import net.javasauce.ss.util.task.TaskInput;

public class DiscordReportTask
extends Task {
    private static final String GS = "\ud83d\udfe9";
    private static final String RS = "\ud83d\udfe5";
    public final TaskInput<String> webhook = this.input("webhook");
    public final TaskInput<String> gitRepoUrl = this.input("repoUrl");
    public final TaskInput<HttpEngine> http = this.input("http");
    public final TaskInput<List<String>> versions = this.input("versions");
    public final TaskInput<Map<String, CommittedTestCasePair>> postDefs = this.input("postDefs");
    public final TaskInput<Map<String, GenerateComparisonsTask.CaseComparison>> comparisons = this.input("comparisons");

    private DiscordReportTask(String name, Executor executor) {
        super(name, executor);
    }

    public static DiscordReportTask create(String name, Executor executor, Consumer<DiscordReportTask> cons) {
        DiscordReportTask task = new DiscordReportTask(name, executor);
        cons.accept(task);
        return task;
    }

    @Override
    protected void execute() throws Throwable {
        String webhook = this.webhook.get();
        String gitRepoUrl = this.gitRepoUrl.get();
        HttpEngine http = this.http.get();
        List<String> versions = this.versions.get();
        Map<String, CommittedTestCasePair> postDefs = this.postDefs.get();
        Map<String, GenerateComparisonsTask.CaseComparison> comparisons = this.comparisons.get();
        ArrayList<DiscordWebhook.Embed> embeds = new ArrayList<DiscordWebhook.Embed>();
        for (String id : versions) {
            GenerateComparisonsTask.CaseComparison comparison = comparisons.get(id);
            if (comparison == null || comparison.type() == GenerateComparisonsTask.ComparisonType.REMOVED) continue;
            CommittedTestCasePair def = Objects.requireNonNull(postDefs.get(id), "CommittedTestCaseDef was expected to exist for id " + id);
            DiscordWebhook.Embed embed = comparison.type() == GenerateComparisonsTask.ComparisonType.ADDED ? DiscordReportTask.buildNewEmbed(gitRepoUrl, id, comparison, def.now().commitTitle()) : DiscordReportTask.buildComparisonEmbed(gitRepoUrl, id, comparison, def.now().commitTitle());
            if (!embed.hasFields()) continue;
            embeds.add(embed);
        }
        DiscordReportTask.postEmbeds(webhook, http, embeds);
    }

    private static void postEmbeds(String webhook, HttpEngine http, List<DiscordWebhook.Embed> embeds) throws IOException {
        for (FastStream bucket : FastStream.of(embeds).partition(10)) {
            new DiscordWebhook(webhook).addEmbeds(bucket.toList()).execute(http);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static DiscordWebhook.Embed buildNewEmbed(String repoUrl, String mcVersion, GenerateComparisonsTask.CaseComparison comparison, String commitTitle) {
        DiscordWebhook.Embed embed = new DiscordWebhook.Embed().setTitle("New version: " + mcVersion).setUrl(repoUrl + "/commit/" + comparison.rightCommit()).setDescription(commitTitle).setColor(new Color(5025616));
        for (TestCaseState state : TestCaseState.VALUES.reversed()) {
            embed.addField(state.humanName, String.valueOf(comparison.numCases()[state.ordinal()]), false);
        }
        return embed;
    }

    private static DiscordWebhook.Embed buildComparisonEmbed(String repoUrl, String mcVersion, GenerateComparisonsTask.CaseComparison comp, String commitTitle) {
        DiscordWebhook.Embed embed = new DiscordWebhook.Embed().setTitle("Version changed: " + mcVersion).setUrl(repoUrl + "/commit/" + comp.rightCommit()).setDescription(commitTitle).setColor(new Color(16750592));
        for (TestCaseState state : TestCaseState.VALUES.reversed()) {
            int i = state.ordinal();
            if (comp.addedTotal()[i] == 0 && comp.removedTotal()[i] == 0) continue;
            Object summary = "";
            if (comp.improvedStats()[i] > 0) {
                summary = "\ud83d\udfe9 " + comp.improvedStats()[i] + " improved";
            }
            if (comp.regressedStats()[i] > 0) {
                if (!((String)summary).isEmpty()) {
                    summary = (String)summary + " ";
                }
                summary = (String)summary + "\ud83d\udfe5 " + comp.regressedStats()[i] + " regressed";
            }
            String nameSuffix = comp.addedTotal()[i] != 0 || comp.removedTotal()[i] != 0 ? "(+" + comp.addedTotal()[i] + " -" + comp.removedTotal()[i] + ")" : "";
            embed.addField(state.humanName + ": " + comp.numCases()[i] + " " + nameSuffix, (String)summary, false);
        }
        return embed;
    }
}

